<?php
/**
 * 2008 - 2019 (c) Prestablog
 *
 * MODULE PrestaBlog
 *
 * @author    Prestablog
 * @copyright Copyright (c) permanent, Prestablog
 * @license   Commercial
 * @version    4.3.1
 */

class SliderClass extends ObjectModel
{
    public $id;
    public $id_shop = 1;
    public $title;
    public $position;
    public $url_associate;

    public $group = array();

    protected $table = 'prestablog_slide';
    protected $identifier = 'id_slide';

    protected static $table_static = 'prestablog_slide';
    protected static $identifier_static = 'id_slide';

    public static $definition = array(
        'table' => 'prestablog_slide',
        'primary' => 'id_slide',
        'multilang' => true,
        'fields' => array(
            'id_shop' => array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt', 'required' => true),
            'title' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isString', 'size' => 255),
            'url_associate' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isString', 'size' => 255),
            'position' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),

        )
    );

    public static function isTableInstalled()
    {
        $table = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SHOW TABLES LIKE \''.bqSQL(_DB_PREFIX_.self::$table_static).'%\'
            ');

        if (count($table) > 0) {
            return true;
        }
        return false;
    }
    public static function updateDatas($id, $id_lang, $title, $url_associate, $position) {

        return Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
            UPDATE `'._DB_PREFIX_.'prestablog_slide_lang`
            SET `title`= \''.$title.'\', `url_associate`= \''.$url_associate.'\',`id_lang`= \''.$id_lang.'\', `position`= \''.$position.'\'
            WHERE `id_slide` = '.(int)$id);
    }


    public static function checkPosition($position, $id_lang) {

        $return1 = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SELECT `id_slide`
            FROM `'.bqSQL(_DB_PREFIX_).'prestablog_slide_lang`
            WHERE `position`= '.(int)$position.' AND `id_lang`= '.(int)$id_lang);
        if (isset($return1[0]) && $return1[0] != null ) {
            return false;
        } else {
            return true;
        }
    }

    public static function slideGetLang($id) {
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SELECT `id_lang`
            FROM `'.bqSQL(_DB_PREFIX_).'prestablog_slide_lang`
            WHERE `id_slide`= '.(int)$id);
    }

    public static function getIdLastSlide() {
         $return1 =  Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SELECT `id_slide` FROM `'.bqSQL(_DB_PREFIX_).'prestablog_slide` ORDER BY id_slide DESC LIMIT 1');

         return $return1[0]['id_slide'];
    }

    public function addTableSlide($id_shop) {
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
            INSERT INTO `'.bqSQL(_DB_PREFIX_).'prestablog_slide`
            (`id_shop`)
                VALUES
                ('.$id_shop.')');
    }

    public function addTableSlideLang($title, $url_associate, $id_lang, $position) {
        $returnId = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SELECT `id_slide` FROM `'.bqSQL(_DB_PREFIX_).'prestablog_slide` ORDER BY id_slide DESC LIMIT 1');

        return Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
            INSERT INTO `'.bqSQL(_DB_PREFIX_).'prestablog_slide_lang`
            (`id_slide`, `title`, `url_associate`, `id_lang`, `position`)
                VALUES
                (\''.$returnId[0]['id_slide'].'\',\''.$title.'\',\''.$url_associate.'\',\''.$id_lang.'\',\''.$position.'\')');
    }


    public function copyFromPost()
    {

        $object = $this;
        $table = $this->table;

        foreach ($_POST as $key => $value) {
            if (array_key_exists($key, $object) && $key != 'id_'.$table) {
                if ($key == 'passwd' && Tools::getValue('id_'.$table) && empty($value)) {
                    continue;
                }
                if ($key == 'passwd' && !empty($value)) {
                    $value = Tools::encrypt($value);
                }
                $object->{$key} = Tools::getValue($key);
            }
        }


        $rules = call_user_func(array(get_class($object), 'getValidationRules'), get_class($object));
        if (count($rules['validateLang'])) {
            $languages = Language::getLanguages(false);
            foreach ($languages as $language) {
                foreach (array_keys($rules['validateLang']) as $field) {
                    if (Tools::getIsset($field.'_'.(int)$language['id_lang'])) {
                        $object->{$field}[(int)$language['id_lang']] = Tools::getValue(
                            $field.'_'.(int)$language['id_lang']
                        );
                    }
                }
            }
        }
    }

    public static function getListSlider($id_lang = null)
    {

        if ($id_lang) {
           $txt = ' WHERE `id_lang` = '.(int)$id_lang;
        } else {
            $txt = '';
        }
        return Db::getInstance()->ExecuteS('
            SELECT id_slide, id_lang, position, title
            FROM `'._DB_PREFIX_.'prestablog_slide_lang`
            '.$txt.'
            ORDER BY position ASC');
    }
    public static function getTitle($id, $id_lang)
    {
        $return1 = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SELECT `title`
            FROM `'.bqSQL(_DB_PREFIX_).'prestablog_slide_lang`
            WHERE `id_slide`= '.(int)$id.' AND `id_lang` ='.(int)$id_lang);

        if (isset($return1[0]['title']))
            return $return1[0]['title'];
    }
    public static function getURL($id, $id_lang)
    {
        $return1 = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SELECT `url_associate`
            FROM `'.bqSQL(_DB_PREFIX_).'prestablog_slide_lang`
            WHERE `id_slide`= '.(int)$id.' AND `id_lang` ='.(int)$id_lang);

        if (isset($return1[0]['url_associate']))
            return $return1[0]['url_associate'];
    }

    public static function getPosition($id, $id_lang)
    {
        $return1 = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SELECT `position`
            FROM `'.bqSQL(_DB_PREFIX_).'prestablog_slide_lang`
            WHERE `id_slide` = '.(int)$id.' AND `id_lang` = '.(int)$id_lang);

        if (isset($return1[0]['position']))
            return $return1[0]['position'];
    }

    public static function getAllSlider($id_lang = null)
    {
        $context = Context::getContext();
        $multiboutique_filtre = '`id_shop` = '.(int)$context->shop->id;
        $lang = '';
        if (empty($id_lang)) {
            $lang = '`id_lang` = '.(int)Configuration::get('PS_LANG_DEFAULT');
        } elseif (is_array($id_lang)) {
            if (count($id_lang) > 0) {
                foreach ($id_lang as $lang_id) {
                    $lang = '`id_lang` = '.(int)$lang_id.' ';
                }
            }
        } else {
            if ((int)$id_lang == 0) {
                $lang = '';
            } else {
                $lang = '`id_lang` = '.(int)$id_lang;
            }
        }
        $test =  Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('SELECT id_slide
            FROM `'._DB_PREFIX_.'prestablog_slide`');

        if (isset($test[0]) && $test[0] != "") {
            $return1 = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                SELECT id_slide
                FROM `'._DB_PREFIX_.'prestablog_slide`
                WHERE '.$multiboutique_filtre);

            $return2 = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                SELECT id_slide, title, url_associate, position
                FROM `'._DB_PREFIX_.'prestablog_slide_lang`
                WHERE '.$lang.'
                ORDER BY position ASC');
        } else {
            $return2[0] = 0;
        }
        return $return2;
    }

    public function registerTablesBdd()
    {
        if (!Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'prestablog_slide_lang` (
            `'.bqSQL($this->identifier).'` int(10) unsigned NOT null,
            `title` varchar(255),
            `url_associate` varchar(255),
            `id_lang` tinyint(1),
            `position` int(10),
            PRIMARY KEY (`'.bqSQL($this->identifier).'`, `id_lang`))
            ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8')) {
            return false;
        }
        if (!Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'prestablog_slide` (
            `'.bqSQL($this->identifier).'` int(10) unsigned NOT null auto_increment,
            `id_shop` tinyint(1),
            PRIMARY KEY (`'.bqSQL($this->identifier).'`))
            ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8')) {
            return false;
        }

        $langues = Language::getLanguages(true);
        if (count($langues) > 0) {
            $langue_use = array();
            foreach ($langues as $value) {
                $langue_use[] = (int)$value['id_lang'];
            }

            if (!Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
                INSERT INTO `'._DB_PREFIX_.'prestablog_slide`
                (`'.bqSQL($this->identifier).'`, `id_shop`)
                VALUES
                (1, 1)')) {
                return false;
            }

            $title = array (
                1 => 'Curabitur venenatis ut elit quis tempus, sed eget sem pretium'
            );


            $url_associate = array (
                1 => 'http://curabitur.fr/fr/blog/curabitur-venenatis-ut-elit-quis-tempus-sed-eget-sem-pretium-n1'
            );


            $sql_values = 'VALUES ';
            for ($i = 1; $i <= 1; $i++) {
                foreach ($langues as $value) {
                    $sql_values .= '
                    (
                    1,
                    \''.$title[$i].'\',
                    \''.pSQL($url_associate[$i]).'\',
                    '.(int)$value['id_lang'].',
                    1
                ),';
            }
        }

        $sql_values = rtrim($sql_values, ',');
        if (!Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
            INSERT INTO `'._DB_PREFIX_.'prestablog_slide_lang`
            (
            `'.bqSQL($this->identifier).'`,
            `title`,
            `url_associate`,
            `id_lang`,
            `position`
            )
            '.$sql_values)) {
            return false;
        }
    }
    return true;
}


public function removeLang($id, $id_lang)
{
    return Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
        DELETE FROM `'._DB_PREFIX_.'prestablog_slide_lang`
        WHERE `id_slide` = '.(int)$id.' AND `id_lang` = '.(int)$id_lang);
}

public function remove($id)
{
    return Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
        DELETE FROM `'._DB_PREFIX_.'prestablog_slide`
        WHERE `id_slide` = '.(int)$id);
}

public function deleteTablesBdd()
{
    if (!Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
        DROP TABLE IF EXISTS `'._DB_PREFIX_.'prestablog_slide`
        ')) {
        return false;
    }
    if (!Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('
        DROP TABLE IF EXISTS `'._DB_PREFIX_.'prestablog_slide_lang`
        ')) {
        return false;
    }

    return true;
}

}
