<?php
/*
 * Since 2007 PayPal
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 *  versions in the future. If you wish to customize PrestaShop for your
 *  needs please refer to http://www.prestashop.com for more information.
 *
 *  @author Since 2007 PayPal
 *  @author 202 ecommerce <tech@202-ecommerce.com>
 *  @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *  @copyright PayPal
 *
 */

namespace PaypalAddons\classes\Webhook;

use PaypalAddons\classes\API\Response\Error;
use PaypalAddons\classes\API\Response\Response;
use PaypalAddons\classes\Constants\WebhookHandler;

if (!defined('_PS_VERSION_')) {
    exit;
}

class WebhookAvailability
{
    /**
     * @return Response
     */
    public function check()
    {
        $response = new Response();
        $curl = curl_init((new WebhookHandlerUrl())->getCheckAvailabilityUrl());
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($curl, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
        curl_exec($curl);
        $info = curl_getinfo($curl);

        if ($info['http_code'] == WebhookHandler::STATUS_AVAILABLE) {
            return $response->setSuccess(true);
        }

        if ($errorMsg = curl_error($curl)) {
            $error = new Error();
            $error->setMessage($errorMsg);
            $response->setError($error);
        }

        return $response->setSuccess(false);
    }
}
