<?php

// Define tableau des solutions
$solution_list = array(
    array(
        'id' => 'prestashop',
        'brand' => 'Prestashop'._l(':').' '._l('all'),
        'logo' => '<img src="lib/img/brand/prestashop.png"/>',
        'external_link' => 'https://www.prestashop.com',
        'actions' => array(),
    ),
    array(
        'id' => 'prestashop_developpers',
        'brand' => 'Prestashop'._l(':').' '._l('for developers'),
        'logo' => '<img src="lib/img/brand/prestashop.png"/>',
        'external_link' => 'https://www.prestashop.com',
        'actions' => array(
            'TRP_CAR_VALID_REF',
            'CAT_PROD_MISSING_PRODUCT_LANG',
            'CAT_PROD_MISSING_PRODUCT_LANG_MS',
            'CAT_PROD_MISSING_PRODUCT_INFORMATION_MS',
            'CAT_PROD_GHOST_PRODUCT',
            'CAT_PROD_WITHOUT_CATEGORY',
            'CAT_PROD_WITHOUT_DEFAULT_CATEGORY',
            'CAT_PROD_PRODUCT_WITHOUT_LINK_REWRITE',
            'CAT_ATTR_MISSING_ATTRIBUTE_LANG',
            'CAT_ATTR_GHOST_ATTRIBUTE',
            'CAT_ATTR_MISSING_GROUP_ATTRIBUTE_LANG',
            'CAT_ATTR_GHOST_GROUP_ATTRIBUTE',
            'TRP_CAR_MISSING_CARRIER_LANG_MS',
            'TRP_CAR_GHOST_CARRIER_MS',
            'CAT_CAT_MISSING_CAT_LANG_MS',
            'CAT_CAT_GHOST_CAT_MS',
            'CAT_CAT_GHOST_CAT_PROD',
            'CAT_ATTR_ASSOCIATION_SHOP',
            'CAT_CAT_GHOST_CAT_PROD_PROD',
            'CAT_CAT_GHOST_CAT_PROD_PROD_DUP',
            'CAT_CAT_GHOST_PARENT',
            'TRP_CTY_MISSING_COUNTRY_LANG',
            'TRP_CTY_GHOST_COUNTRY',
            'CAT_FEA_MISSING_FEATURE_LANG',
            'CAT_FEA_GHOST_FEATURE',
            'CAT_FEA_GHOST_CAT_PROD',
            'CAT_FEA_MISSING_FEATURE_VALUE_LANG',
            'CAT_FEA_GHOST_FEATURE_VALUE',
            'CUS_GRP_MISSING_GROUP_LANG',
            'CAT_PRODUCT_TAX_DELETED',
            'CUS_GRP_GHOST_GROUP',
            'CAT_MAN_MISSING_MANUFACTURER_LANG',
            'CAT_MAN_GHOST_MANUFACTURER',
            'CAT_SUP_MISSING_SUPPLIER_LANG',
            'CAT_SUP_GHOST_SUPPLIER',
            'CAT_TAX_MISSING_TAX_LANG',
            'CAT_TAX_GHOST_TAX',
            'GEN_ATH_MISSING_ATTACHMENT_LANG',
            'GEN_ATH_GHOST_ATTACHMENT',
            'GEN_CMS_MISSING_CMS_CATEGORY_LANG',
            'GEN_CMS_GHOST_CMS_CATEGORY',
            'GEN_CMS_MISSING_CMS_LANG',
            'GEN_CMS_GHOST_CMS',
            'CMD_STA_MISSING_ORDER_STATE_LANG',
            'CMD_STA_GHOST_ORDER_STATE',
            'MUL_DAT_GHOST_SHOP',
            'MUL_DAT_MISSING_SHOP',
            'CAT_STK_GHOST_STOCK_AVAILABLE',
            'CAT_PROD_MISSING_COVER_IMAGE',
            'CAT_PROD_DESC_HIDDEN_CARAC',
            'CAT_PROD_DIFF_ADVANCEDSTOCKS_MODE',
            'CAT_ATTR_GHOST_ATTRIBUTE_IN_WAREHOUSE',
            'CAT_PROD_PRODUCT_WITH_COMBI_IN_WAREHOUSE',
            'CAT_CAT_WRONG_PARENT',
            'CAT_PROD_NOT_SAME_ATTRIBUTES',
            'CAT_PROD_LANG_WITH_EMPTY_SHOP',
            'MUL_DAT_EMPTY_ID_SHOP',
            'MUL_DAT_LANG_EMPTY_ID_SHOP',
            'CAT_COMBI_WITHOUT_STOCK_ROW',
            'CAT_PRODUCT_WITHOUT_STOCK_ROW',
            'CAT_PRODUCT_IMG_SHOP_EMPTY_PRODUCT',
            'CAT_PROD_MISSING_IMAGE_LANG',
            'CAT_STK_TOO_MUCH_COMBI_STOCK_AVAILABLE',
            'CAT_PROD_GHOST_MS',
            'CAT_FEA_DOUBLE_PRODUCT',
            'CAT_FEA_FEATURE_VALUE_NOTEXIST',
            'SEC_FIL_INSTALL_LICENCES',
            'SEC_FIL_GIT_FILES',
            'SEC_SMARTY_CACHE',
            'SEC_BLOCKWISHLIST',
            'SEC_FIL_DOCS_FILES',
            'SEC_FIL_ROBOTS',
            'SEC_PWD_SAME_PASSWORD',
            'SEC_PWD_EMAIL_TEMPLATE_PASSWORD',
            'SEC_SER_PHP_VERSION',
            'SEC_FIL_PHPUNIT_BREACH',
            'SEC_TWIG_BREACH',
        ),
    ),
    array(
        'id' => 'prestashop_sellers',
        'brand' => 'Prestashop'._l(':').' '._l('for sellers'),
        'logo' => '<img src="lib/img/brand/prestashop.png"/>',
        'external_link' => 'https://www.prestashop.com',
        'actions' => array(
            'CAT_PROD_GHOST_PRODUCT',
            'CAT_PROD_WITHOUT_CATEGORY',
            'CAT_PROD_WITHOUT_DEFAULT_CATEGORY',
            'CAT_PROD_PRODUCT_WITHOUT_LINK_REWRITE',
            'CAT_ATTR_ASSOCIATION_SHOP',
            'CAT_CAT_GHOST_CAT_PROD_PROD',
            'CAT_CAT_GHOST_CAT_PROD_PROD_DUP',
            'CAT_PRODUCT_ASSOCIATION_SHOP',
            'CAT_PRODUCT_IMG_POSITIONS',
            'CAT_PRODUCT_TAX_DELETED',
            'MUL_DAT_GHOST_SHOP',
            'MUL_DAT_MISSING_SHOP',
            'CAT_PROD_MISSING_COVER_IMAGE',
            'CAT_PROD_CUSTOM_FEATURE',
            'CAT_PROD_DESC_HIDDEN_CARAC',
            'CAT_PROD_DIFF_ADVANCEDSTOCKS_MODE',
            'CAT_SUP_GHOST_PRODUCT_COMBI_SUPPLIER',
            'CAT_PROD_NOT_SAME_ATTRIBUTES',
            'CAT_PROD_WITHOUT_DEFAULT_COMBI',
            'CAT_AND_PROD_NOT_SHARING_SHOP',
            'CAT_COMBI_GHOST_MS',
            'CAT_COMBI_PRODUCT_NOT_SHOP_SHARED',
            'CAT_PRODUCT_DUPLICATE_REFERENCE',
            'CAT_PRODUCT_DUPLICATE_NAME',
            'CAT_PRODUCT_DUPLICATE_UPC',
            'CAT_PRODUCT_DUPLICATE_EAN',
            'CAT_COMBI_DUPLICATE_REFERENCE',
            'CAT_COMBI_DUPLICATE_UPC',
            'CAT_COMBI_DUPLICATE_EAN',
            'CAT_PRODUCT_COMBI_DUPLICATE_EAN',
            'CAT_PRODUCT_COMBI_DUPLICATE_REFERENCE',
            'CAT_PRODUCT_COMBI_DUPLICATE_UPC',
            'CUS_DB_DUPLICATE_EMAIL',
            'CAT_SEO_DUPLICATE_META_DESC',
            'CAT_SEO_DUPLICATE_META_TITLE',
            'CAT_PROD_EMPTY_CUSTOM_FEATURE',
            'CUS_CHECK_RGPD',
            'SEC_FIL_INSTALL_LICENCES',
            'SEC_SMARTY_CACHE',
            'SEC_BLOCKWISHLIST',
            'SEC_FIL_DOCS_FILES',
            'SEC_PWD_SAME_PASSWORD',
            'SEC_FIL_PHPUNIT_BREACH',
            'SEC_TWIG_BREACH',
            'SEC_DB_EMPLOYEE_NO_LOGON_3MONTHS',
        ),
    ),
    array(
        'id' => 'catalog_PDF',
        'brand' => _l('Prepare a PDF catalog'),
        'logo' => '<img src="lib/img/white_stripes.png"/>',
        'actions' => array(
            'CAT_PROD_GHOST_PRODUCT',
            'CAT_PROD_WITHOUT_CATEGORY',
            'CAT_PROD_WITHOUT_DEFAULT_CATEGORY',
            'CAT_ATTR_MISSING_ATTRIBUTE_LANG',
            'CAT_ATTR_MISSING_GROUP_ATTRIBUTE_LANG',
            'CAT_CAT_MISSING_CAT_LANG',
            'CAT_CAT_GHOST_CAT_PROD',
            'CAT_ATTR_ASSOCIATION_SHOP',
            'CAT_CAT_GHOST_CAT_PROD_PROD',
            'CAT_CAT_GHOST_CAT_PROD_PROD_DUP',
            'CAT_CAT_GHOST_PARENT',
            'CAT_PRODUCT_ASSOCIATION_SHOP',
            'CAT_FEA_MISSING_FEATURE_LANG',
            'CAT_FEA_GHOST_CAT_PROD',
            'CAT_PRODUCT_IMG_POSITIONS',
            'CAT_FEA_MISSING_FEATURE_VALUE_LANG',
            'CAT_PRODUCT_TAX_DELETED',
            'CAT_MAN_MISSING_MANUFACTURER_LANG',
            'CAT_SUP_MISSING_SUPPLIER_LANG',
            'CAT_TAX_MISSING_TAX_LANG',
            'CAT_PROD_MISSING_COVER_IMAGE',
            'CAT_PROD_DESC_HIDDEN_CARAC',
            'CAT_CAT_WRONG_PARENT',
            'CAT_PROD_NOT_SAME_ATTRIBUTES',
            'CAT_PROD_WITHOUT_DEFAULT_COMBI',
            'CAT_AND_PROD_NOT_SHARING_SHOP',
            'CAT_COMBI_GHOST_MS',
            'CAT_COMBI_PRODUCT_NOT_SHOP_SHARED',
            'CAT_PROD_GHOST_MS',
            'CAT_FEA_FEATURE_VALUE_NOTEXIST',
            'CAT_PRODUCT_DUPLICATE_REFERENCE',
            'CAT_PRODUCT_DUPLICATE_NAME',
            'CAT_PRODUCT_DUPLICATE_UPC',
            'CAT_PRODUCT_DUPLICATE_EAN',
            'CAT_COMBI_DUPLICATE_REFERENCE',
            'CAT_COMBI_DUPLICATE_UPC',
            'CAT_COMBI_DUPLICATE_EAN',
            'CAT_PRODUCT_COMBI_DUPLICATE_EAN',
            'CAT_PRODUCT_COMBI_DUPLICATE_REFERENCE',
            'CAT_PRODUCT_COMBI_DUPLICATE_UPC',
            'CAT_PROD_EMPTY_CUSTOM_FEATURE',
        ),
    ),
    array(
        'id' => 'security',
        'brand' => _l('Secure your shop'),
        'logo' => '<img src="lib/img/white_stripes.png"/>',
        'actions' => array(
            'SEC_ADMIN_PAGINATION_SQL_BREACH',
            'SEC_BLOCKWISHLIST',
            'SEC_FIL_DOCKER',
            'SEC_FIL_DOCS_FILES',
            'SEC_FIL_INSTALL_LICENCES',
            'SEC_FIL_PHPUNIT_BREACH',
            'SEC_FIL_ROBOTS',
            'SEC_FRONT_CUSTOMER_FORM_BREACH',
            'SEC_PWD_EMAIL_TEMPLATE_PASSWORD',
            'SEC_PWD_SAME_PASSWORD',
            'SEC_SER_PHP_VERSION',
            'SEC_SMARTY_CACHE',
            'SEC_TWIG_BREACH',
            'GEN_SER_SC_VERSION',
            'SEC_FIL_GIT_FILES',
            'SEC_UNINSTALLED_MODULES',
            'SEC_DISABLED_MODULES',
            'SEC_DB_EMPLOYEE_NO_LOGON_3MONTHS',
        ),
    ),
// TEST
//    array(
//        'id' => 'paypal',
//        'brand' => 'PayPal',
//        'logo' => '<img src="lib/img/brand/paypal.png" width="80" height="auto"/>',
//        'external_link' => 'https://www.paypal.com',
//        'actions' => array(
//            'CAT_PRODUCT_TAX_DELETED',
//            'CAT_TAX_GHOST_TAX',
//            'CAT_TAX_GHOST_TAX',
//        )
//    )
);

# # Check si solutions suplémentaires
if (file_exists(SC_TOOLS_DIR.basename(dirname(__FILE__)).'/solutions.php'))
{
    require_once SC_TOOLS_DIR.basename(dirname(__FILE__)).'/solutions.php';
}

// Actions
$action = Tools::getValue('action', null);
if (!empty($action))
{
    switch ($action)
    {
        default:
            exit(json_encode($solution_list));
    }
}
else
{
    exit(_l('Error'));
}
